/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.externalge;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.kernel.types.PspGeList;
import jpcsp.Memory;
import jpcsp.graphics.RE.externalge.ExternalGE;
import jpcsp.util.DurationStatistics;
import jpcsp.util.Hash;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class NativeCallbacks {
    private static final Logger log = Logger.getLogger((String)"NativeCallbacks");
    private static DurationStatistics read32 = new DurationStatistics("read32");
    private static DurationStatistics readByteBuffer = new DurationStatistics("readByteBuffer");
    private static DurationStatistics writeByteBuffer = new DurationStatistics("writeByteBuffer");
    private static DurationStatistics writeByteBufferArea = new DurationStatistics("writeByteBufferArea");
    private static DurationStatistics getHashCode = new DurationStatistics("getHashCode");
    private static DurationStatistics onRenderSprite = new DurationStatistics("onRenderSprite");
    private static final Logger[] logs = new Logger[]{log, Logger.getLogger((String)"externalge")};

    public static void exit() {
    }

    private static Memory getMemory() {
        return Memory.getInstance();
    }

    public static int read32(int address) {
        return NativeCallbacks.getMemory().read32(address);
    }

    public static int read16(int address) {
        return NativeCallbacks.getMemory().read16(address);
    }

    public static int read8(int address) {
        return NativeCallbacks.getMemory().read8(address);
    }

    public static int readByteBuffer(int address, ByteBuffer destination, int length) {
        readByteBuffer.start();
        Buffer source = NativeCallbacks.getMemory().getBuffer(address, length);
        int offset = 0;
        if (source != null) {
            if (source instanceof IntBuffer) {
                offset = address & 3;
            }
            Utilities.putBuffer(destination, source, ByteOrder.LITTLE_ENDIAN, length + offset);
        }
        readByteBuffer.end();
        return offset;
    }

    public static void write32(int address, int value) {
        NativeCallbacks.getMemory().write32(address, value);
    }

    public static void write16(int address, short value) {
        NativeCallbacks.getMemory().write16(address, value);
    }

    public static void write8(int address, byte value) {
        NativeCallbacks.getMemory().write8(address, value);
    }

    public static void copy(int destination, int source, int length) {
        NativeCallbacks.getMemory().memcpy(destination, source, length);
    }

    public static void writeByteBuffer(int address, ByteBuffer source, int length) {
        writeByteBuffer.start();
        if (RuntimeContext.hasMemoryInt() && (address & 3) == 0 && (length & 3) == 0 && Memory.isAddressGood(address)) {
            IntBuffer destination = IntBuffer.wrap(RuntimeContext.getMemoryInt(), (address & 0x1FFFFFFF) >> 2, length >> 2);
            source.order(ByteOrder.nativeOrder());
            destination.put(source.asIntBuffer());
        } else {
            NativeCallbacks.getMemory().copyToMemory(address, source, length);
        }
        writeByteBuffer.end();
    }

    public static void writeByteBufferArea(int address, ByteBuffer source, int bufferWidth, int width, int height) {
        writeByteBufferArea.start();
        if (RuntimeContext.hasMemoryInt() && (address & 3) == 0 && (width & 3) == 0 && (bufferWidth & 3) == 0 && Memory.isAddressGood(address)) {
            int length = bufferWidth * height;
            int destinationOffset = (address & 0x1FFFFFFF) >> 2;
            IntBuffer destination = IntBuffer.wrap(RuntimeContext.getMemoryInt(), destinationOffset, length >> 2);
            source.order(ByteOrder.nativeOrder());
            IntBuffer sourceInt = source.asIntBuffer();
            int width4 = width >> 2;
            int bufferWidth4 = bufferWidth >> 2;
            for (int y = 0; y < height; ++y) {
                int offset = y * bufferWidth4;
                sourceInt.limit(offset + width4);
                sourceInt.position(offset);
                destination.position(destinationOffset + offset);
                destination.put(sourceInt);
            }
        } else {
            Memory mem = NativeCallbacks.getMemory();
            for (int y = 0; y < height; ++y) {
                int offset = y * bufferWidth;
                source.position(offset);
                mem.copyToMemory(address + offset, source, width);
            }
        }
        writeByteBufferArea.end();
    }

    public static int getHashCode(int hashCode, int addr, int lengthInBytes, int strideInBytes) {
        getHashCode.start();
        int value = Hash.getHashCode(hashCode, addr, lengthInBytes, strideInBytes);
        getHashCode.end();
        return value;
    }

    public static void log(int category, int level, String message) {
        Logger log = category >= 0 && category < logs.length ? logs[category] : NativeCallbacks.log;
        switch (level) {
            case 0: {
                break;
            }
            case 1: {
                log.fatal((Object)message);
                break;
            }
            case 2: {
                log.error((Object)message);
                break;
            }
            case 3: {
                log.warn((Object)message);
                break;
            }
            case 4: {
                log.info((Object)message);
                break;
            }
            case 5: {
                log.debug((Object)message);
                break;
            }
            case 6: {
                log.trace((Object)message);
                break;
            }
            case 7: {
                log.info((Object)message);
                break;
            }
            default: {
                log.error((Object)String.format("Unknown log level %d: %s", level, message));
            }
        }
    }

    public static void onRenderSprite(int textureAddress, int renderedTextureWidth, int renderedTextureHeight, int textureFormat) {
        onRenderSprite.start();
        PspGeList currentList = ExternalGE.getCurrentList();
        if (currentList != null) {
            currentList.onRenderSprite(textureAddress, renderedTextureWidth, renderedTextureHeight, textureFormat);
        }
        onRenderSprite.end();
    }
}

